<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit;

include_once __DIR__ . '/connection.php';
include_once __DIR__ . "/config.php";

// Input
$data = json_decode(file_get_contents("php://input"), true);
$user_id = intval($data['user_id'] ?? 0);

if (!$user_id) {
    echo json_encode(["success"=>false,"transactions"=>[]]);
    exit;
}

// Fetch all transactions for user
$stmt = $conn->prepare("SELECT id, trade_id, type, description, amount, status, created_at as date FROM transactions WHERE user_id=? ORDER BY id DESC");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$transactions = [];
while($row = $result->fetch_assoc()){
    $transactions[] = $row;
}

echo json_encode(["success"=>true, "transactions"=>$transactions]);
?>
