<?php
header('Content-Type: application/json');

// CORS
$origin = $_SERVER['HTTP_ORIGIN'] ?? '';
$allowedOrigins = ['https://admin.ecotradefx.com', 'http://localhost:3000'];
if (in_array($origin, $allowedOrigins)) {
    header("Access-Control-Allow-Origin: $origin");
    header("Access-Control-Allow-Credentials: true");
} else {
    header("Access-Control-Allow-Origin: *");
}
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit;

// Include DB
include_once __DIR__ . '/config.php';

// Get input JSON
$input = file_get_contents("php://input");
$data = json_decode($input, true);
$filterStatus = isset($data['status']) ? strtolower($data['status']) : null;

// Base query
$query = "
    SELECT * FROM (
        SELECT dr.id AS request_id,
               dr.trade_id,
               COALESCE(lu.email, 'N/A') AS email,
               dr.amount,
               dr.type,
               dr.status,
               dr.transaction_proof,
               dr.comment AS admin_comment,
               dr.created_at,
               'request' AS source
        FROM deposit_requests dr
        LEFT JOIN liveaccounts l ON l.trade_id = dr.trade_id
        LEFT JOIN loginusers lu ON lu.id = l.user_id

        UNION ALL

        SELECT wd.id AS request_id,
               wd.trade_id,
               wd.email,
               wd.deposit_amount AS amount,
               wd.deposit_type AS type,
               CASE wd.Status
                    WHEN 1 THEN 'approved'
                    WHEN 2 THEN 'rejected'
                    ELSE 'unknown'
               END AS status,
               wd.image AS transaction_proof,
               wd.AdminRemark AS admin_comment,
               wd.deposed_date AS created_at,
               'approved' AS source
        FROM wallet_deposit wd
    ) AS combined
";

if ($filterStatus) {
    $filterStatus = $conn->real_escape_string($filterStatus);
    $query .= " WHERE status = '$filterStatus'";
}

$query .= " ORDER BY created_at DESC";

$result = $conn->query($query);

if ($result) {
    $deposits = [];
    while ($row = $result->fetch_assoc()) {
        $deposits[] = $row;
    }
    echo json_encode(["status" => "success", "data" => $deposits]);
} else {
    echo json_encode(["status" => "error", "message" => $conn->error]);
}
