<?php
/**
 * ZForex Trading Platform - Main Configuration File
 * Includes database connection, mail system, and all application settings
 */

// ================================
// DATABASE CONFIGURATION
// ================================
define("DB_HOST", "localhost");
define("DB_USER", "crmcentrioglobal_ecotradefx");
define("DB_PASS", "crmcentrioglobal_ecotradefx");
define("DB_NAME", "crmcentrioglobal_ecotradefx");

// Create mysqli connection
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("❌ Database connection failed: " . $conn->connect_error);
}

// ================================
// MAIL SYSTEM CONFIGURATION
// ================================



define("MAIL_HOST", "smtpout.secureserver.net"); // Custom webmail SMTP host
define("MAIL_PORT", 465); // 465 for SSL (as specified)
define("MAIL_USERNAME", "support@ecotradefx.com"); // Support email address
define("MAIL_PASSWORD", "support@ecotradefx.com"); // Email password for webmail
define("MAIL_ENCRYPTION", "ssl"); // ssl for port 465
define("MAIL_FROM_EMAIL", "support@ecotradefx.com"); // From email address
define("MAIL_FROM_NAME", "EcoTradeFX"); // From name
define("BRAND_NAME", "EcoTradeFX"); // Brand name for templates

// ================================
// EMAIL TEMPLATE SETTINGS
// ================================
define('EMAIL_AUTOMATION_ENABLED', true);
define('LOG_PATH', __DIR__ . '/logs/');
define('COMPANY_NAME', 'EcoTradeFX');
define('COMPANY_WEBSITE', 'https://ecotradefx.com');
define('SUPPORT_EMAIL', 'support@ecotradefx.com');
define('COMPANY_ADDRESS', 'Your Company Address');

// ================================
// APPLICATION SETTINGS
// ================================
define('APP_NAME', 'EcoTradeFX');
define('APP_URL', 'https://client.ecotradefx.com');
define('APP_ENVIRONMENT', 'development'); // development, staging, production

// ================================
// MT5 API CONFIGURATION
// ================================


// ================================
// MAIL SYSTEM INTEGRATION
// ================================
// Include the integrated mail system
if (file_exists(__DIR__ . '/mail_system/integrated_mail_system.php')) {
    require_once __DIR__ . '/mail_system/integrated_mail_system.php';
    
    // Initialize mail system for global use
    $mailSystem = getMailSystem();
    
    // Make mail functions globally available
    if (!function_exists('sendWelcomeEmail')) {
        function sendWelcomeEmail($to, $name, $loginUrl = '') {
            global $mailSystem;
            return $mailSystem->sendWelcomeEmail($to, $name, $loginUrl);
        }
    }
    
    if (!function_exists('sendPasswordResetEmail')) {
        function sendPasswordResetEmail($to, $name, $resetLink) {
            global $mailSystem;
            return $mailSystem->sendPasswordResetEmail($to, $name, $resetLink);
        }
    }
    
    if (!function_exists('sendDepositConfirmationEmail')) {
        function sendDepositConfirmationEmail($to, $name, $amount, $method, $transactionId) {
            global $mailSystem;
            return $mailSystem->sendDepositConfirmationEmail($to, $name, $amount, $method, $transactionId);
        }
    }
    
    if (!function_exists('sendWithdrawalConfirmationEmail')) {
        function sendWithdrawalConfirmationEmail($to, $name, $amount, $method, $transactionId) {
            global $mailSystem;
            return $mailSystem->sendWithdrawalConfirmationEmail($to, $name, $amount, $method, $transactionId);
        }
    }
    
    if (!function_exists('sendKYCApprovalEmail')) {
        function sendKYCApprovalEmail($to, $name) {
            global $mailSystem;
            return $mailSystem->sendKYCApprovalEmail($to, $name);
        }
    }
    
    if (!function_exists('sendKYCRejectionEmail')) {
        function sendKYCRejectionEmail($to, $name, $reason) {
            global $mailSystem;
            return $mailSystem->sendKYCRejectionEmail($to, $name, $reason);
        }
    }
    
    if (!function_exists('sendAccountVerificationEmail')) {
        function sendAccountVerificationEmail($to, $name, $verificationLink) {
            global $mailSystem;
            return $mailSystem->sendAccountVerificationEmail($to, $name, $verificationLink);
        }
    }
    
    if (!function_exists('sendTradingAccountCreatedEmail')) {
        function sendTradingAccountCreatedEmail($to, $name, $accountNumber, $accountType, $leverage) {
            global $mailSystem;
            return $mailSystem->sendTradingAccountCreatedEmail($to, $name, $accountNumber, $accountType, $leverage);
        }
    }
    
} else {
    // Mail system not available - log warning
    error_log("⚠️ Mail system not found at: " . __DIR__ . '/mail_system/integrated_mail_system.php');
}

// ================================
// CORS HEADERS
// ================================
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

?>