<?php
// Script to send all 22 email templates to sagarnandal95@gmail.com

// Include test configuration
require_once 'test_mail_config.php';

// Include only the mail system
require_once 'mail_system/integrated_mail_system.php';

// Test user data
$first_name = 'Sagar';
$last_name = 'Nandal';
$email = 'sagarnandal95@gmail.com';

echo "📧 Sending All 22 Email Templates to: $email\n";
echo "==========================================\n\n";

$mailSystem = getMailSystem();
$fullName = $first_name . ' ' . $last_name;

// Test all 22 templates
$tests = [
    // 1. Register Verification
    'register_verification' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendRegisterVerification($email, $fullName, 'VER123456', '24 hours');
    },
    
    // 2. After Verify Credentials
    'after_verify_credentials' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendAfterVerifyCredentials($email, $fullName, 'USR789012');
    },
    
    // 3. Login Alert
    'login_alert' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendLoginAlert($email, $fullName, '192.168.1.100', 'Chrome on Windows');
    },
    
    // 4. Live Account Opened
    'open_live_account' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendLiveAccountOpened($email, $fullName, 'ACC123456789', 'Standard', '100', 'USD');
    },
    
    // 5. KYC Upload
    'kyc_upload' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendKYCUpload($email, $fullName, 'KYC987654', 'ID Document, Address Proof');
    },
    
    // 6. KYC Approved
    'kyc_approved' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendKYCApproved($email, $fullName, 'Full', 'September 30, 2025');
    },
    
    // 7. Deposit Request Submitted
    'deposit_request_submitted' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendDepositRequestSubmitted($email, $fullName, 1000, 'USD', 'Bank Transfer', 'DEP123456');
    },
    
    // 8. Deposit Approved
    'deposit_approved' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendDepositApproved($email, $fullName, 1000, 'USD', 5000, 'TXN789012');
    },
    
    // 9. Deposit Failed
    'deposit_failed' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendDepositFailed($email, $fullName, 500, 'USD', 'Insufficient funds', 'DEP345678');
    },
    
    // 10. Withdrawal OTP
    'otp_withdrawal' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendWithdrawalOTP($email, $fullName, '987654', 500, 'USD', 'Bank Account ****1234', '10 minutes');
    },
    
    // 11. Withdrawal Request Submitted
    'withdrawal_request_submitted' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendWithdrawalRequestSubmitted($email, $fullName, 500, 'USD', 'Bank Transfer', 'WTH123456');
    },
    
    // 12. Withdrawal Approved
    'withdrawal_approved' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendWithdrawalApproved($email, $fullName, 500, 'USD', 'TXN987654', '2-3 business days', 4500);
    },
    
    // 13. Withdrawal Rejected
    'withdrawal_rejected' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendWithdrawalRejected($email, $fullName, 500, 'USD', 'Invalid bank details', 'WTH789012');
    },
    
    // 14. IB Commission Withdrawal
    'ib_commission_withdrawal' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendIBCommissionWithdrawal($email, $fullName, 150, 'USD', 'September 2025', 5);
    },
    
    // 15. Referral Registration
    'referral_registration' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendReferralRegistration($email, $fullName, 'John Smith', '5');
    },
    
    // 16. Trade Opened
    'trade_opened' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendTradeOpened($email, $fullName, 'EUR/USD', 'BUY', '0.1', '1.0850');
    },
    
    // 17. Trade Closed
    'trade_closed' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendTradeClosed($email, $fullName, 'EUR/USD', '0.1', '1.0800', '1.0900', 10.50, 'USD', '2 hours');
    },
    
    // 18. Daily Trade Summary
    'daily_trade_summary' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendDailyTradeSummary($email, $fullName, 'September 30, 2025', 15, 10, 5, 125.75, 'USD', 5125.75);
    },
    
    // 19. Password Reset
    'password_reset' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendPasswordReset($email, $fullName, 'RESET123456', '1 hour');
    },
    
    // 20. Password Changed
    'password_changed' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendPasswordChanged($email, $fullName, '192.168.1.100');
    },
    
    // 21. Profile Updated
    'profile_updated' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendProfileUpdated($email, $fullName, 'Email, Phone Number');
    },
    
    // 22. Monthly Statement
    'monthly_statement' => function() use ($mailSystem, $email, $fullName) {
        return $mailSystem->sendMonthlyStatement($email, $fullName, 'September', '2025', 125, 567.89, 'USD', 10000, 5000, 15678.89);
    }
];

$successCount = 0;
$totalCount = count($tests);

echo "Sending $totalCount emails...\n\n";

// Run all tests
foreach ($tests as $templateName => $testFunction) {
    echo "Sending: $templateName\n";
    
    try {
        $result = $testFunction();
        
        if ($result['success']) {
            $successCount++;
            echo "  ✅ SUCCESS: " . $result['message'] . "\n";
        } else {
            echo "  ❌ FAILED: " . $result['message'] . "\n";
        }
    } catch (Exception $e) {
        echo "  ❌ EXCEPTION: " . $e->getMessage() . "\n";
    }
    
    // Add a small delay between emails
    sleep(2);
}

echo "\n📊 Results Summary:\n";
echo "==================\n";
echo "Total Emails: $totalCount\n";
echo "Successfully Sent: $successCount\n";
echo "Failed: " . ($totalCount - $successCount) . "\n";
$successRate = ($totalCount > 0) ? round(($successCount / $totalCount) * 100, 2) : 0;
echo "Success Rate: {$successRate}%\n\n";

echo "🎉 Please check your email inbox at $email for all $totalCount emails!\n";
echo "The emails may take a few minutes to arrive depending on your email provider.\n";
?>