<?php
/**
 * Quick Mail Example with Updated Gmail Credentials
 * Ready to use examples for sending emails
 */

require_once 'mail_system.php';

// Example 1: Send Registration Verification Email
function sendRegistrationEmail($userEmail, $userName, $verificationToken) {
    return sendZForexMail(
        $userEmail,
        $userName,
        'register_verification',
        [
            'verification_url' => "https://yoursite.com/verify.php?token=" . $verificationToken
        ]
    );
}

// Example 2: Send Login Credentials
function sendLoginCredentials($userEmail, $userName, $loginId, $password) {
    return sendZForexMail(
        $userEmail,
        $userName,
        'login_credentials',
        [
            'login_id' => $loginId,
            'password' => $password,
            'login_url' => 'https://yoursite.com/login.php'
        ]
    );
}

// Example 3: Send Deposit Confirmation
function sendDepositConfirmation($userEmail, $userName, $amount, $transactionId) {
    return sendZForexMail(
        $userEmail,
        $userName,
        'deposit_request',
        [
            'amount' => $amount,
            'transaction_id' => $transactionId,
            'processing_time' => '24 hours'
        ]
    );
}

// Example 4: Send Password Reset
function sendPasswordReset($userEmail, $userName, $resetToken) {
    return sendZForexMail(
        $userEmail,
        $userName,
        'password_reset',
        [
            'reset_url' => "https://yoursite.com/reset.php?token=" . $resetToken,
            'expiry_time' => '1 hour'
        ]
    );
}

// Test the functions (uncomment to test)
/*
echo "Testing email functions...\n";

// Test registration email
$result1 = sendRegistrationEmail('sagarnandal95@gmail.com', 'Sagar Nandal', 'abc123token');
echo $result1['success'] ? "✅ Registration email sent\n" : "❌ Failed: " . $result1['message'] . "\n";

// Test login credentials
$result2 = sendLoginCredentials('sagarnandal95@gmail.com', 'Sagar Nandal', 'SN001', 'temp123');
echo $result2['success'] ? "✅ Login credentials sent\n" : "❌ Failed: " . $result2['message'] . "\n";
*/

echo "📧 Mail system ready with Gmail credentials!\n";
echo "📝 Use the functions above in your application\n";
echo "🔧 Current settings: sagarnandal95@gmail.com via smtp.gmail.com\n";

?>