<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include 'config.php';  // Database connection

// Fetch all users from loginusers table
$sql = "SELECT id, first_name, last_name, email, phone, country, password, kyc_status, email_confirmed 
        FROM loginusers 
        ORDER BY id DESC";

$result = $conn->query($sql);

$clients = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        // Map fields for frontend
        $clients[] = [
            "id" => $row['id'],
            "trade_id" => "N/A", // No trade_id in loginusers
            "account_name" => $row['first_name'] . ' ' . $row['last_name'],
            "email" => $row['email'],
            "phone_pwd" => $row['phone'],
            "strategycountry" => $row['country'],
            "status" => "Enabled", // Hardcoded
            "email_kyc" => $row['email_confirmed'],
            "password" => $row['password'],       // Add password
            "kyc_status" => $row['kyc_status']    // Add kyc_status
        ];
    }
}

echo json_encode([
    "success" => true,
    "clients" => $clients
]);
?>
